function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = GK_financial.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(71, 1);
lhs = y(63);
rhs = T(5)*y(24)+T(7)*y(110);
residual(1) = lhs - rhs;
lhs = y(22);
rhs = y(24)+T(7)*y(93);
residual(2) = lhs - rhs;
lhs = y(23);
rhs = y(24)-params(34)*(y(39)-(steady_state(18)))^2+T(7)*y(94);
residual(3) = lhs - rhs;
lhs = y(24);
rhs = T(9)*T(10);
residual(4) = lhs - rhs;
lhs = y(27);
rhs = (1-params(3))*y(2)/T(4)+(1-y(28))*y(30)*y(31);
residual(5) = lhs - rhs;
lhs = y(29);
rhs = T(4)*y(30)/y(3);
residual(6) = lhs - rhs;
lhs = y(28);
rhs = params(9)*(y(29)-1-T(1))^2;
residual(7) = lhs - rhs;
lhs = y(32);
rhs = (y(29)-1-T(1))*2*params(9);
residual(8) = lhs - rhs;
lhs = y(33);
rhs = (1-params(6))*y(24)/T(8)-T(11)/(T(4)*y(96)-y(25)*params(7));
residual(9) = lhs - rhs;
lhs = y(34);
rhs = (-y(92))/y(33);
residual(10) = lhs - rhs;
lhs = 1;
rhs = y(36)*y(101)*T(3);
residual(11) = lhs - rhs;
lhs = 1;
rhs = y(31)*y(38)*(1-y(28)-y(29)*y(32))+T(13)*y(98);
residual(12) = lhs - rhs;
lhs = y(37);
rhs = y(7)/y(40);
residual(13) = lhs - rhs;
lhs = y(92);
rhs = y(24)*(-(1-params(6)))*T(14);
residual(14) = lhs - rhs;
lhs = y(41);
rhs = y(40)*T(4)*y(42)/y(9);
residual(15) = lhs - rhs;
lhs = y(43);
rhs = y(34)*T(15)*y(44)*y(45)+T(3)*T(4)*params(11)*T(18)*y(105);
residual(16) = lhs - rhs;
lhs = y(46);
rhs = y(44)+T(3)*params(11)*T(21)*y(106);
residual(17) = lhs - rhs;
lhs = y(47);
rhs = y(43)/(y(42)*y(46));
residual(18) = lhs - rhs;
lhs = 1;
rhs = params(11)*T(23)^(1-params(5))+(1-params(11))*y(47)^(1-params(5));
residual(19) = lhs - rhs;
lhs = y(48);
rhs = params(11)*T(24)/T(25)*y(11)+(1-params(11))*y(47)^(-params(5));
residual(20) = lhs - rhs;
lhs = y(49);
rhs = T(26)*T(28);
residual(21) = lhs - rhs;
lhs = y(42);
rhs = y(49)*params(2)*y(51)/y(44);
residual(22) = lhs - rhs;
lhs = y(35);
rhs = y(49)*(1-params(2))*y(51)/T(27);
residual(23) = lhs - rhs;
lhs = y(52);
rhs = y(51);
residual(24) = lhs - rhs;
lhs = y(53);
rhs = y(52)*T(30)*y(55)+T(3)*T(4)*params(10)*T(33)*y(107);
residual(25) = lhs - rhs;
lhs = y(56);
rhs = y(54)+T(3)*T(4)*params(10)*T(36)*y(108);
residual(26) = lhs - rhs;
lhs = y(57);
rhs = y(53)/y(56);
residual(27) = lhs - rhs;
lhs = 1;
rhs = params(10)*T(38)^(1-params(4))+(1-params(10))*y(57)^(1-params(4));
residual(28) = lhs - rhs;
lhs = y(58);
rhs = params(10)*T(39)/T(40)*y(15)+(1-params(10))*y(57)^(-params(4));
residual(29) = lhs - rhs;
lhs = log(T(41));
rhs = params(17)*log(T(42))+(1-params(17))*(params(18)*log(T(43))+params(19)*log(T(44))+params(20)*log(T(45)))+log(y(59));
residual(30) = lhs - rhs;
lhs = y(54);
rhs = y(30)+y(25)+y(60);
residual(31) = lhs - rhs;
lhs = y(26);
rhs = y(44)*y(48);
residual(32) = lhs - rhs;
lhs = y(49);
rhs = y(54)*y(58);
residual(33) = lhs - rhs;
lhs = y(61);
rhs = (y(35)+(1-params(3))*y(38))/y(6);
residual(34) = lhs - rhs;
lhs = y(62);
rhs = y(61)-y(37);
residual(35) = lhs - rhs;
lhs = y(68);
rhs = (y(35)+(1-params(3))*y(64))/y(18);
residual(36) = lhs - rhs;
lhs = y(69);
rhs = y(64)*y(66)/(y(38)*y(65));
residual(37) = lhs - rhs;
lhs = y(70)*y(71);
rhs = (1+y(70))*(y(72)+y(69)*y(73));
residual(38) = lhs - rhs;
lhs = y(70)*y(74);
rhs = (1+y(70))*y(73);
residual(39) = lhs - rhs;
lhs = y(75);
rhs = y(76)/(y(71)-(y(72)+y(69)*y(73)));
residual(40) = lhs - rhs;
lhs = y(76);
rhs = y(101)*T(3)*y(112);
residual(41) = lhs - rhs;
lhs = y(72);
rhs = T(3)*y(112)*(y(109)-y(101));
residual(42) = lhs - rhs;
lhs = y(73);
rhs = T(3)*y(112)*(y(101)-y(111));
residual(43) = lhs - rhs;
lhs = y(77);
rhs = 1-params(28)+y(75)*y(71)*params(28);
residual(44) = lhs - rhs;
lhs = y(38)*y(65);
rhs = y(64)*y(66)+y(78)+y(67);
residual(45) = lhs - rhs;
lhs = y(78);
rhs = y(79)+y(80);
residual(46) = lhs - rhs;
lhs = y(79);
rhs = T(46)*((y(35)+(1-params(3))*y(38))*y(19)-(y(35)+(1-params(3))*y(64))*y(20)-y(37)*y(21));
residual(47) = lhs - rhs;
lhs = y(80);
rhs = y(65)*(y(35)+(1-params(3))*y(38))*T(47);
residual(48) = lhs - rhs;
lhs = y(75);
rhs = y(38)*y(65)/y(78);
residual(49) = lhs - rhs;
lhs = 1;
rhs = T(3)*y(111);
residual(50) = lhs - rhs;
lhs = y(65);
rhs = y(27);
residual(51) = lhs - rhs;
lhs = y(71);
rhs = y(82)*T(49);
residual(52) = lhs - rhs;
lhs = y(74);
rhs = y(82)*(params(31)+y(69)*y(83));
residual(53) = lhs - rhs;
lhs = log(y(50))-log((steady_state(29)));
rhs = params(21)*(log(y(12))-log((steady_state(29))))+x(it_, 1);
residual(54) = lhs - rhs;
lhs = log(y(60))-log((steady_state(39)));
rhs = params(22)*(log(y(17))-log((steady_state(39))))+x(it_, 2);
residual(55) = lhs - rhs;
lhs = log(y(55))-log((steady_state(34)));
rhs = params(23)*(log(y(14))-log((steady_state(34))))+x(it_, 3);
residual(56) = lhs - rhs;
lhs = log(y(45))-log((steady_state(24)));
rhs = params(24)*(log(y(10))-log((steady_state(24))))+x(it_, 6);
residual(57) = lhs - rhs;
lhs = log(y(31))-log((steady_state(10)));
rhs = params(27)*(log(y(4))-log((steady_state(10))))+x(it_, 5);
residual(58) = lhs - rhs;
lhs = log(y(59))-log((steady_state(38)));
rhs = params(25)*(log(y(16))-log((steady_state(38))))+x(it_, 4);
residual(59) = lhs - rhs;
lhs = log(y(36))-log((steady_state(15)));
rhs = params(26)*(log(y(5))-log((steady_state(15))))+x(it_, 7);
residual(60) = lhs - rhs;
lhs = y(84);
rhs = log(T(4)*T(45));
residual(61) = lhs - rhs;
lhs = y(85);
rhs = log(T(50));
residual(62) = lhs - rhs;
lhs = y(90);
rhs = log(T(51));
residual(63) = lhs - rhs;
lhs = y(91);
rhs = log(T(52));
residual(64) = lhs - rhs;
lhs = y(88);
rhs = (y(44)-(steady_state(23)))/(steady_state(23));
residual(65) = lhs - rhs;
lhs = y(87);
rhs = y(39)-1;
residual(66) = lhs - rhs;
lhs = y(86);
rhs = log(y(40));
residual(67) = lhs - rhs;
lhs = y(89);
rhs = y(62);
residual(68) = lhs - rhs;
lhs = y(82);
rhs = (steady_state(61));
residual(69) = lhs - rhs;
lhs = y(81);
rhs = (steady_state(60));
residual(70) = lhs - rhs;
lhs = y(83);
rhs = (steady_state(62));
residual(71) = lhs - rhs;

end
